/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.option.SpruceOptionSliderWidget;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class SpruceDoubleOption
extends SpruceOption {
    protected final float step;
    protected final double min;
    protected double max;
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;
    private final Function<SpruceDoubleOption, class_2561> displayStringGetter;

    public SpruceDoubleOption(String key, double min, double max, float step, Supplier<Double> getter, Consumer<Double> setter, Function<SpruceDoubleOption, class_2561> displayStringGetter, @NotNull TooltipData tooltip) {
        super(key);
        this.min = min;
        this.max = max;
        this.step = step;
        this.getter = getter;
        this.setter = setter;
        this.displayStringGetter = displayStringGetter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceOptionSliderWidget slider = new SpruceOptionSliderWidget(position, width, 20, this);
        this.getTooltip().ifPresent(slider::setTooltip);
        return slider;
    }

    public double getRatio(double value) {
        return class_3532.method_15350((double)((this.adjust(value) - this.min) / (this.max - this.min)), (double)0.0, (double)1.0);
    }

    public double getValue(double ratio) {
        return this.adjust(class_3532.method_16436((double)class_3532.method_15350((double)ratio, (double)0.0, (double)1.0), (double)this.min, (double)this.max));
    }

    private double adjust(double value) {
        if (this.step > 0.0f) {
            value = this.step * (float)Math.round(value / (double)this.step);
        }
        return class_3532.method_15350((double)value, (double)this.min, (double)this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void set(double value) {
        this.setter.accept(value);
    }

    public double get() {
        return this.getter.get();
    }

    public class_2561 getDisplayString() {
        return this.displayStringGetter.apply(this);
    }

    public static class Builder
    extends SpruceOption.Builder<Builder, SpruceDoubleOption> {
        protected final float step;
        protected final double min;
        protected double max;
        private final Supplier<Double> getter;
        private final Consumer<Double> setter;
        private final Function<SpruceDoubleOption, class_2561> displayStringGetter;

        public Builder(String key, double min, double max, float step, Supplier<Double> getter, Consumer<Double> setter, Function<SpruceDoubleOption, class_2561> displayStringGetter) {
            super(key);
            this.min = min;
            this.max = max;
            this.step = step;
            this.getter = getter;
            this.setter = setter;
            this.displayStringGetter = displayStringGetter;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpruceDoubleOption build() {
            return new SpruceDoubleOption(this.key, this.min, this.max, this.step, this.getter, this.setter, this.displayStringGetter, this.tooltip);
        }
    }
}

